import { mockRoute } from '../testUtils';
import { parseAndCompareRoute } from '.';

describe(parseAndCompareRoute, () => {
  it('handles the empty query case', () => {
    const router = mockRoute();

    expect(parseAndCompareRoute(router, [])).toEqual({
      changed: false,
      route: {
        asPath: router.asPath,
        pathname: router.pathname,
        query: router.query,
      },
    });
  });

  it('does not strip a preserved param from asPath', () => {
    const router = mockRoute({ query: { foo: 'bar' } });

    expect(parseAndCompareRoute(router, ['foo'])).toEqual({
      changed: false,
      route: {
        asPath: router.asPath,
        pathname: router.pathname,
        query: router.query,
      },
    });
  });

  it('flags a non-preserved query case and strips from asPath', () => {
    const router = mockRoute({ query: { foo: 'bar' } });

    expect(parseAndCompareRoute(router, [])).toEqual({
      changed: true,
      route: {
        asPath: '/',
        pathname: router.pathname,
        query: router.query,
      },
    });
  });

  it('flags a partially preserved query case and strips the un-preserved param from asPath', () => {
    const router = mockRoute({
      query: { baz: 'boop', foo: 'bar' },
    });

    expect(parseAndCompareRoute(router, ['baz'])).toEqual({
      changed: true,
      route: {
        asPath: '/?baz=boop',
        pathname: router.pathname,
        query: router.query,
      },
    });
  });
});
