import type { ParsedUrlQuery } from 'querystring';
import { stringify } from 'querystring';

/**
 * Returns a query string for a given query object with non-preserved params
 * removed.
 */
export function queryStringForPreserved(
  query: ParsedUrlQuery,
  preservedParams: string[],
): string {
  // using empty string since this matches the cases where none of the
  // current params match any of the params to preserve
  if (preservedParams.length === 0) {
    return '';
  }

  const preservedObject = Object.entries(query).reduce<ParsedUrlQuery>(
    (acc, [param, value]) => {
      if (preservedParams.includes(param)) {
        acc[param] = value;
      }

      return acc;
    },
    {},
  );

  return stringify(preservedObject);
}
