import type { ParsedUrlQuery } from 'querystring';
import { queryStringForPreserved } from '.';

describe(queryStringForPreserved, () => {
  it.each`
    query                                   | preserved          | expected
    ${{}}                                   | ${[]}              | ${''}
    ${{ foo: 'bar' }}                       | ${[]}              | ${''}
    ${{ foo: 'bar' }}                       | ${['foo']}         | ${'foo=bar'}
    ${{ boop: 'baz', foo: 'bar' }}          | ${['foo']}         | ${'foo=bar'}
    ${{ boop: 'baz', foo: 'bar' }}          | ${['foo', 'boop']} | ${'boop=baz&foo=bar'}
    ${{ boop: ['baz', 'bop'], foo: 'bar' }} | ${['foo', 'boop']} | ${'boop=baz&boop=bop&foo=bar'}
  `(
    'for $query and $preserved returns $expected',
    ({
      expected,
      preserved,
      query,
    }: {
      expected: string;
      preserved: string[];
      query: ParsedUrlQuery;
    }) => {
      expect(queryStringForPreserved(query, preserved)).toEqual(expected);
    },
  );
});
