import type { FC } from 'react';
import type { RouterUtilsContext } from './RouterUtilsRoot';
import { routerUtilsContext } from './RouterUtilsRoot';

// istanbul ignore file: mocks

export function mockRouterUtils(
  overrides?: Partial<RouterUtilsContext>,
): RouterUtilsContext {
  return {
    currentAsPath: '/',
    currentPathname: '/',
    currentQuery: {},
    lastPathname: undefined,
    pageCount: 1,
    ...overrides,
  };
}

export type MockRouterUtilsProviderProps = {
  value?: Partial<RouterUtilsContext>;
};

/**
 * Use to provide a Mock RouterUtilsProvider in tests that expect a
 * Router Utils Context to be available.
 */
export const MockRouterUtilsProvider: FC<MockRouterUtilsProviderProps> = ({
  children,
  value,
}) => {
  const context = mockRouterUtils(value);
  return (
    <routerUtilsContext.Provider value={context}>
      {children}
    </routerUtilsContext.Provider>
  );
};

MockRouterUtilsProvider.displayName = 'MockRouterUtilsProvider';
