import { stringify } from 'querystring';
import type { NextRouter } from 'next/router';

export type MockRoute = Pick<NextRouter, 'asPath' | 'pathname' | 'query'>;

export type MockRouter = Pick<
  NextRouter,
  'asPath' | 'pathname' | 'query' | 'replace'
>;

export function mockRoute(overrides?: Partial<MockRoute>): MockRoute {
  const r = {
    asPath: '/',
    pathname: '/',
    query: {},
    ...overrides,
  };

  const routeParts = r.asPath.split('?');
  const path = routeParts[0];
  const asPathQueryString = routeParts[1] || '';
  const stringForQuery = stringify(r.query);
  const queryMismatch = stringForQuery !== asPathQueryString;

  // Avoids the need for having to manually add query strings to asPath for
  // mocking convenience
  if (queryMismatch) {
    r.asPath = `${path}?${stringForQuery}`;
  }

  return r;
}

/**
 * Returns a mock router for test purposes.
 */
export function mockRouter(overrides?: Partial<MockRouter>): NextRouter {
  const r: MockRouter = {
    replace: jest.fn(),
    ...mockRoute(overrides),
  };

  return r as NextRouter;
}
