import { createMountWrapperFactory } from 'tachyon-test-utils';
import { MockRouterUtilsProvider } from '../test-mocks';
import { useRouterUtils } from '.';

describe(useRouterUtils, () => {
  const TestElement = () => {
    const utils = useRouterUtils();
    return <div id="target">{JSON.stringify(utils)}</div>;
  };

  const setup = createMountWrapperFactory(MockRouterUtilsProvider, () => ({
    children: <TestElement />,
    value: {
      currentAsPath: '/',
      currentPathname: '/',
      currentQuery: {},
      lastPathname: undefined,
      pageCount: 1,
    },
  }));

  it('consumes the context as expected', () => {
    const { props, wrapper } = setup();
    expect(wrapper.find('#target').text()).toEqual(JSON.stringify(props.value));
  });
});
