import type { ComponentType, FC } from 'react';
import { getComponentName } from 'tachyon-utils-react';
import type { RouterUtilsContext } from '../RouterUtilsRoot';
import { useRouterUtils } from '../useRouterUtils';

/**
 * Props for mixing into components wrapped by withRouterUtils.
 */
export type RouterUtilsProps = {
  routerUtils: RouterUtilsContext;
};

// istanbul ignore next: trivial
/**
 * withRouterUtils is a HOC that provides the queryParams for the current page
 * load as well as the pageCount and currentRouteName
 *
 * @param Comp A component which needs access to query param data.
 */
export function withRouterUtils<P extends RouterUtilsProps>(
  Comp: ComponentType<P>,
): FC<Omit<P, keyof RouterUtilsProps>> {
  const RouterUtils: FC<Omit<P, keyof RouterUtilsProps>> = (props) => {
    const routerUtils = useRouterUtils();
    const newProps = {
      ...props,
      routerUtils,
    } as P;

    return <Comp {...newProps} />;
  };
  RouterUtils.displayName = `RouterUtils(${getComponentName(Comp)})`;
  return RouterUtils;
}
