import { lorem } from 'faker';
import type { FC } from 'react';
import { createMountWrapperFactory } from 'tachyon-test-utils';
import type { RouterUtilsContext } from '../RouterUtilsRoot';
import { MockRouterUtilsProvider } from '../test-mocks';
import type { RouterUtilsProps } from '.';
import { withRouterUtils } from '.';

describe(withRouterUtils, () => {
  describe('passes the Router utils context to the consumer as routerUtils', () => {
    const RouterUtilsConsumerBase: FC<RouterUtilsProps> = () => {
      return <div />;
    };

    const RouterUtilsConsumer = withRouterUtils(RouterUtilsConsumerBase);

    const TestComponent = (props: RouterUtilsContext) => {
      return (
        <MockRouterUtilsProvider value={props}>
          <RouterUtilsConsumer />
        </MockRouterUtilsProvider>
      );
    };

    const setup = createMountWrapperFactory(TestComponent, () => ({
      currentAsPath: '/',
      currentPathname: '/',
      currentQuery: {
        a: lorem.word(),
        b: lorem.word(),
      },
      lastPathname: undefined,
      pageCount: 1,
    }));

    it('passes correct query params to child', () => {
      const { props, wrapper } = setup();
      expect(wrapper.find(RouterUtilsConsumerBase).prop('routerUtils')).toEqual(
        props,
      );
    });
  });
});
