import type { AppContext, AppInitialProps, AppProps } from 'next/app';
import type { FC } from 'react';
import type {
  TachyonPageContext,
  TachyonPageInitialProps,
  TachyonPageProps,
  TachyonPageType,
} from './page';

export type TachyonAppBaseInitialProps = Omit<AppInitialProps, 'pageProps'> & {
  pageProps: TachyonPageInitialProps;
};

export type TachyonAppContext<
  ReqExt = {},
  PageContextExt = {},
  PageExtension = {},
> = Omit<AppContext, 'Component' | 'ctx'> & {
  Component: TachyonPageType<
    TachyonPageInitialProps,
    TachyonPageProps,
    PageExtension
  >;
  ctx: TachyonPageContext<{}, ReqExt, PageContextExt>;
};

export type TachyonAppBaseProps<PageExtension = {}, PagePropsExt = {}> = Omit<
  AppProps,
  'Component' | 'pageProps'
> & {
  Component: TachyonPageType<
    TachyonPageInitialProps,
    PagePropsExt & TachyonPageProps,
    PageExtension
  >;
  pageProps: TachyonPageInitialProps;
};

export type TachyonAppFC<
  InitialProps extends {},
  Props extends InitialProps,
  ReqExt = {},
  PageContextExt = {},
  PageExtension = {},
> = FC<
  Props & TachyonAppBaseInitialProps & TachyonAppBaseProps<PageExtension>
> & {
  getInitialProps: (
    ctx: TachyonAppContext<ReqExt, PageContextExt, PageExtension>,
  ) => Promise<InitialProps>;
};
