import type { TachyonRequest, TachyonResponse } from './common';

// NextApiRequest and NextApiResponse include "preview"-related fields for SSG,
// but we omit them currently. Otherwise, they just expose a subset of the
// normal Express shapes (which are already bundled).

export type TachyonApiRequest<ReqExt = {}> = TachyonRequest<ReqExt>;
export type TachyonApiResponse<ResBody = any> = TachyonResponse<ResBody>;

export type TachyonApiHandler<ResBody, ReqExt = {}> = (
  req: TachyonApiRequest<ReqExt>,
  res: TachyonApiResponse<ResBody>,
) => Promise<void> | void;
