import { renderHook } from '@testing-library/react-hooks';
import { useSetTimeoutFn } from '.';

describe(useSetTimeoutFn, () => {
  beforeAll(() => {
    window.clearTimeout = jest.fn();
  });

  it('returns a stable fn', () => {
    const { rerender, result } = renderHook(useSetTimeoutFn);
    const first = result.current;

    rerender();
    const second = result.current;

    expect(first).toEqual(second);
  });

  it('clears outstanding timers when unmounting', () => {
    const { result, unmount } = renderHook(useSetTimeoutFn);

    result.current(jest.fn());
    result.current(jest.fn());

    unmount();

    expect(window.clearTimeout).toHaveBeenCalledTimes(2);
  });
});
