import type { ErrorLogPayload } from 'tachyon-logger';
import { logger } from 'tachyon-logger';
import type { TachyonPageContext } from 'tachyon-next-types';
import { HTTPStatusCode } from 'tachyon-type-library';
import { titleCase } from 'tachyon-utils-stdlib';

type ErrorPageConfig = Pick<ErrorLogPayload, 'package'>;

export type ErrorInitialProps = {
  statusCode?: number | null | undefined;
};

export const errorGetInitialProps = (
  config: ErrorPageConfig,
  { err, res }: TachyonPageContext,
): ErrorInitialProps => {
  const statusCode = res?.statusCode ?? err?.statusCode;

  // error boundaries will have handled errors on the client
  // don't log 404s because they are not errors
  if (statusCode !== HTTPStatusCode.NotFound && typeof window === 'undefined') {
    try {
      logger.error({
        category: `${titleCase(config.package)}ErrorPage`,
        error: err,
        message: err?.message ?? 'No message on error page',
        package: config.package,
      });
    } catch {
      // Don't let the logger kill us since we're already on the error page.
    }
  }

  return { statusCode };
};
