import { convertToUnsafeID } from 'tachyon-relay';
import { mockChannel } from '../utils/test-utils';
import { channelAboutPageviewTracking } from '.';

describe(channelAboutPageviewTracking, () => {
  it('returns pageview data', () => {
    const channel = mockChannel();
    const queryResponse = { channel };

    expect(channelAboutPageviewTracking(queryResponse)).toEqual({
      channel: channel.login,
      channelID: convertToUnsafeID(channel.id),
      isLive: true,
      location: 'channel_about',
    });
  });
});
