import { convertToUnsafeID } from 'tachyon-relay';
import { mockChannel } from '../utils/test-utils';
import { channelClipsPageviewTracking } from '.';

describe(channelClipsPageviewTracking, () => {
  it('returns pageview data', () => {
    const channel = mockChannel();
    const queryResponse = { channel };

    expect(channelClipsPageviewTracking(queryResponse)).toEqual({
      channel: channel.login,
      channelID: convertToUnsafeID(channel.id),
      isLive: true,
      location: 'channel_clips',
    });
  });
});
