import { convertToUnsafeID } from 'tachyon-relay';
import { mockChannel } from '../utils/test-utils';
import { channelSchedulePageviewTracking } from '.';

describe(channelSchedulePageviewTracking, () => {
  it('returns pageview data', () => {
    const channel = mockChannel();
    const queryResponse = { channel };

    expect(channelSchedulePageviewTracking(queryResponse)).toEqual({
      channel: channel.login,
      channelID: convertToUnsafeID(channel.id),
      isLive: true,
      location: 'channel_schedule',
    });
  });
});
