import { internet } from 'faker';
import { validId } from 'tachyon-relay';
import type { ChannelTrackingFragment, HostingChannel } from '.';

export const mockChannel = (): HostingChannel<ChannelTrackingFragment> => ({
  hosting: null,
  id: validId(),
  login: internet.userName(),
  stream: {
    game: {
      name: internet.userName(),
    },
    id: validId(),
  },
});

export const mockHostedStream = (): ChannelTrackingFragment => ({
  id: validId(),
  login: internet.userName(),
  stream: {
    game: {
      name: internet.userName(),
    },
    id: validId(),
  },
});
