import type { TachyonPageContext } from 'tachyon-next-types';
import { flattenHeaderOrParam } from 'tachyon-utils-stdlib';
import type {
  ChannelInitialProps,
  ChannelPageviewTracking,
  ChannelPathParameters,
} from '../utils';
import {
  channelPageviewTrackingBase,
  channelPathGetInitialProps,
} from '../utils';

export const CHANNEL_VODS_FILTER_QUERY_PARAM_KEY = 'filter';

export type ChannelVodsPathParameters = ChannelPathParameters & {
  [CHANNEL_VODS_FILTER_QUERY_PARAM_KEY]?: string;
};

export type ChannelVodsInitialProps<QueryVariables extends {} = {}> =
  ChannelInitialProps<QueryVariables> & {
    activeShelfType: VideoShelfType | null;
  };

type VideoShelfType =
  // eslint-disable-next-line relay/no-future-added-value
  | '%future added value'
  | 'ALL_VIDEOS'
  | 'COLLECTION'
  | 'GAME'
  | 'LATEST_BROADCASTS'
  | 'LATEST_NON_BROADCASTS'
  | 'LONG_VIDEOS'
  | 'SHORT_VIDEOS'
  | 'TOP_CLIPS';

type VideosFilter = 'all' | 'archives' | 'highlights';

export const getChannelVodsFilter = (
  type?: VideoShelfType,
): VideosFilter | null => {
  switch (type) {
    case 'LATEST_BROADCASTS':
      return 'archives';
    case 'LATEST_NON_BROADCASTS':
      return 'highlights';
    case 'ALL_VIDEOS':
      return 'all';
    default:
      return null;
  }
};

export const getChannelVodsShelfType = (
  filter?: string,
): VideoShelfType | null => {
  switch (filter) {
    case 'all':
      return 'ALL_VIDEOS';
    case 'highlights':
      return 'LATEST_NON_BROADCASTS';
    case 'archives':
      return 'LATEST_BROADCASTS';
    default:
      return null;
  }
};

export function channelVodsGetInitialProps<
  Context extends TachyonPageContext<ChannelVodsPathParameters>,
  QueryVariables extends {} = {},
>(
  context: Context,
  queryVars: QueryVariables = {} as QueryVariables,
): ChannelVodsInitialProps<QueryVariables> {
  const filterQueryParam = flattenHeaderOrParam(
    context.query[CHANNEL_VODS_FILTER_QUERY_PARAM_KEY],
  );

  return {
    ...channelPathGetInitialProps(context, queryVars),
    activeShelfType: getChannelVodsShelfType(filterQueryParam),
  };
}

export const channelVodsPageviewTracking: ChannelPageviewTracking = ({
  channel,
}) => channelPageviewTrackingBase(channel, { location: 'channel_vods' });
