import { convertToUnsafeID } from 'tachyon-relay';
import { mockChannel } from '../utils/test-utils';
import { channelWatchPageviewTracking } from '.';

describe(channelWatchPageviewTracking, () => {
  it('returns pageview data', () => {
    const channel = mockChannel();
    const queryResponse = { channel };

    expect(channelWatchPageviewTracking(queryResponse)).toEqual({
      channel: channel.login,
      channelID: convertToUnsafeID(channel.id),
      game: channel.stream?.game?.name,
      isLive: true,
      location: 'channel',
    });
  });
});
