import { getAndExtendCookieValue, setCookieValue } from 'tachyon-utils-twitch';

const OLD_ACCEPTED_COOKIES_NAME = 'accepted_cookie_notice';
const ACCEPTED_COOKIES_NAME = 'tachyon-accepted-cookie-notice';

// istanbul ignore next: trivial
export function needsToAcceptCookies(): boolean {
  return (
    getAndExtendCookieValue({
      migrationNames: [OLD_ACCEPTED_COOKIES_NAME],
      name: ACCEPTED_COOKIES_NAME,
    }) !== 'true'
  );
}

// istanbul ignore next: trivial
export function acceptCookies(): void {
  setCookieValue({
    name: ACCEPTED_COOKIES_NAME,
    value: 'true',
  });
}

export const OLD_THEME_COOKIE_NAME = 'prefers_color_scheme';
export const THEME_COOKIE_NAME = 'tachyon-prefers-color-scheme';

// istanbul ignore next: trivial
/**
 * Saves a user's theme preference
 */
export function setThemeCookie(theme: string): void {
  setCookieValue({
    name: THEME_COOKIE_NAME,
    value: theme,
  });
}
