import { convertToUnsafeID, isValidObject } from 'tachyon-relay';
import { safeLogin } from 'tachyon-utils-twitch';

export type LoggedInCurrentUser = {
  id: string;
  login: string;
};

export type CurrentUserResponse = {
  currentUser?: {
    id: string;
    login: string;
  } | null;
};

export function getCurrentUser({
  currentUser,
}: CurrentUserResponse): LoggedInCurrentUser | null {
  if (!isValidObject(currentUser)) {
    return null;
  }

  return {
    id: convertToUnsafeID(currentUser.id),
    login: safeLogin(currentUser.login),
  };
}
