import { convertToSafeID } from 'tachyon-relay';
import { getCurrentUser } from '.';

describe(getCurrentUser, () => {
  it('returns null for an object without current user info', () => {
    expect(getCurrentUser({})).toBeNull();
  });

  it('returns null for a garbage object', () => {
    expect(
      getCurrentUser({
        currentUser: null,
      }),
    ).toBeNull();
  });

  it('returns a valid object for a valid currentUser', () => {
    expect(
      getCurrentUser({
        currentUser: {
          id: convertToSafeID('user', '1234'),
          login: 'THErealderekt',
        },
      }),
    ).toEqual({
      id: '1234',
      login: 'therealderekt',
    });
  });
});
