import { logFlume } from 'tachyon-event-reporter';
import { logger } from 'tachyon-logger';
import type { TachyonApiHandler } from 'tachyon-next-types';
import { HTTPStatusCode } from 'tachyon-type-library';
import { errorMessageFromCatch } from 'tachyon-utils-stdlib';
import { getCurrentTwitchDomain } from 'tachyon-utils-twitch';

/**
 * API handler for safely accepting potential flume payloads
 */
export const flumeHandler: TachyonApiHandler<never> = (req, res) => {
  // don't process requests to unexpected domains
  if (!getCurrentTwitchDomain(req.hostname)) {
    logger.log({
      category: 'flumeHandler',
      context: { hostname: req.hostname },
      message: 'Bad flume request',
      package: 'tachyon-page-utils',
    });
    res.sendStatus(HTTPStatusCode.BadRequest);
    return;
  }

  try {
    const { data } = req.body;

    if (data) {
      logFlume(data);
    }
  } catch (e) {
    logger.log({
      category: 'flumeHandler',
      context: { error: errorMessageFromCatch(e) },
      message: 'Error handling flume payload',
      package: 'tachyon-page-utils',
    });
  }

  res.sendStatus(HTTPStatusCode.NoContent);
};
