import type { PageviewProps } from 'tachyon-event-tracker';
import type { TachyonPageContext } from 'tachyon-next-types';

type MinimalGame = {
  name: string;
};

type GameQueryResponse = {
  game: MinimalGame | null;
};

export type GamePathParameters = {
  gameAlias: string;
};

export type GameInitialProps<QueryVariables extends {} = {}> = {
  queryVariables: GamePathParameters & QueryVariables;
};

export function gameGetInitialProps<
  Context extends TachyonPageContext<GamePathParameters>,
  QueryVariables extends {} = {},
>(
  context: Context,
  queryVars: QueryVariables = {} as QueryVariables,
): GameInitialProps<QueryVariables> {
  return {
    queryVariables: {
      ...queryVars,
      gameAlias: context.query.gameAlias.toLowerCase(),
    },
  };
}

type GamePageview = Pick<PageviewProps, 'game'>;

export function gamePageviewTracking({
  game,
}: GameQueryResponse): GamePageview {
  return {
    game: game?.name,
  };
}
