import { internet } from 'faker';
import type { TachyonPageContext } from 'tachyon-next-types';
import type { GamePathParameters } from '.';
import { gameGetInitialProps, gamePageviewTracking } from '.';

const mockGame = {
  name: internet.userName(),
};

describe(gamePageviewTracking, () => {
  it('returns pageview data', () => {
    const queryResponse = { game: mockGame };
    expect(gamePageviewTracking(queryResponse)).toEqual({
      game: mockGame.name,
    });
  });
});

describe(gameGetInitialProps, () => {
  const gameAlias = 'Halo%20Infinite';

  it('extracts gameAlias', () => {
    const res = gameGetInitialProps({
      query: {
        gameAlias,
      },
    } as TachyonPageContext<GamePathParameters>);

    expect(res).toEqual({
      queryVariables: {
        gameAlias: 'halo%20infinite',
      },
    });
  });

  it('adds additional query variables when provided', () => {
    const vars = { extra: true };

    const res = gameGetInitialProps(
      {
        query: {
          gameAlias,
        },
      } as TachyonPageContext<GamePathParameters>,
      vars,
    );

    expect(res).toEqual({
      queryVariables: {
        ...vars,
        gameAlias: 'halo%20infinite',
      },
    });
  });
});
