import type { ErrorLogPayload } from 'tachyon-logger';
import { logger } from 'tachyon-logger';
import type { TachyonPageContext } from 'tachyon-next-types';
import { HTTPStatusCode } from 'tachyon-type-library';
import { flattenHeaderOrParam, titleCase } from 'tachyon-utils-stdlib';

export const ERROR_TEST_QUERY_PARAM = 'fire-drill';

type NotFoundConfig = Pick<ErrorLogPayload, 'package'>;

/**
 * This provides "fire drill" functionality which causes a synthetic server side
 * error to be reported in order to validate our app specific
 * CloudWatch / Metric Filter / PagerDuty alerting.
 */
export const notFoundGetInitialProps = (
  config: NotFoundConfig,
  { req, res }: TachyonPageContext,
): {} => {
  if (typeof window === 'undefined' && res) {
    res.statusCode = HTTPStatusCode.NotFound;

    const fireDrillMessage = flattenHeaderOrParam(
      req?.query?.[ERROR_TEST_QUERY_PARAM],
    );

    if (fireDrillMessage) {
      logger.error({
        category: `${titleCase(config.package)}FireDrill`,
        message: fireDrillMessage,
        package: config.package,
      });
    }
  }
  return {};
};
