import { logger } from 'tachyon-logger';
import type { TachyonPageContext } from 'tachyon-next-types';
import { HTTPStatusCode } from 'tachyon-type-library';
import { ERROR_TEST_QUERY_PARAM, notFoundGetInitialProps } from '.';

const mockLogger = logger;
jest.mock('tachyon-logger', () => ({
  logger: {
    error: jest.fn(),
  },
}));

describe(notFoundGetInitialProps, () => {
  const config = { package: 'page-utils' };
  const getInitialProps = (ctx: TachyonPageContext) =>
    notFoundGetInitialProps(config, ctx);

  beforeEach(() => (mockLogger.error as jest.Mock).mockReset());

  describe('when serverside', () => {
    let mockWindow: any;
    beforeEach(() => {
      mockWindow = jest.spyOn(global as any, 'window', 'get');
      mockWindow.mockImplementation(() => undefined);
    });

    afterEach(() => {
      mockWindow.mockRestore();
    });

    it('logs the fireDrillMessage message when present', () => {
      getInitialProps({
        req: { query: { [ERROR_TEST_QUERY_PARAM]: 't' } } as any,
        res: {},
      } as TachyonPageContext);

      expect(mockLogger.error).toHaveBeenCalledWith({
        category: 'Page-utilsFireDrill',
        error: undefined,
        message: 't',
        package: config.package,
      });
    });

    it('does not logs when fireDrillMessage is not present', () => {
      getInitialProps({
        req: { query: {} } as any,
        res: {},
      } as TachyonPageContext);

      expect(mockLogger.error).toHaveBeenCalledTimes(0);
    });

    it('sets the statusCode to NotFound', () => {
      const res = { statusCode: undefined } as any;
      getInitialProps({ res } as TachyonPageContext);

      expect(res.statusCode).toEqual(HTTPStatusCode.NotFound);
    });
  });
});
