import type { ClipParams } from 'pulsar-player-core';
import { VideoType } from 'pulsar-player-core';
import { convertToUnsafeID, isValidObject } from 'tachyon-relay';

export type PulsarClipFragment = {
  id: string;
  slug: string;
};

type PulsarClipData = {
  clip: PulsarClipFragment | null;
};

export function clipPulsarParams({ clip }: PulsarClipData): ClipParams | null {
  if (!isValidObject(clip)) {
    return null;
  }

  const { id, slug } = clip;

  return {
    clip: {
      id: convertToUnsafeID(id),
      slug,
    },
    type: VideoType.Clip,
  };
}
