import { VideoType } from 'pulsar-player-core';
import { convertToUnsafeID, validId } from 'tachyon-relay';
import { clipPulsarParams } from '.';

describe(clipPulsarParams, () => {
  it('maps a valid video to Pulsar params', () => {
    const clip = {
      broadcaster: {
        id: '54654654',
        login: 'therealderekt',
        roles: {
          isPartner: true,
        },
        self: {
          subscriptionBenefit: {
            id: '123',
          },
        },
      },
      game: {
        name: 'League of Legends',
      },
      id: validId(),
      slug: 'RambunctiousMeddlingKappaStealer',
      thumbnailURL: 'https://cdn.twitch.tv/{height}x{width}',
    };

    expect(
      clipPulsarParams({
        clip,
      }),
    ).toEqual({
      clip: {
        id: convertToUnsafeID(clip.id),
        slug: clip.slug,
      },
      type: VideoType.Clip,
    });
  });
});
