import { validId } from 'tachyon-relay';
import type { PulsarClipFragment } from './clip';
import type { PulsarVodFragment } from './vod';

// istanbul ignore file: test mocks
// These utils are exported from the package so do not use Faker / Jest
// utilities in them.
export function mockPulsarVodFragment(
  overrides?: Partial<PulsarVodFragment>,
): PulsarVodFragment {
  return {
    id: validId(),
    ...overrides,
  };
}

export function mockPulsarClipFragment(
  overrides?: Partial<PulsarClipFragment>,
): PulsarClipFragment {
  return {
    id: validId(),
    slug: 'RambunctiousMeddlingKappaStealer',
    ...overrides,
  };
}
