import type { VideoParams } from 'pulsar-player-core';
import { VideoType } from 'pulsar-player-core';
import { convertToUnsafeID, isValidObject } from 'tachyon-relay';

export type PulsarVodFragment = {
  id: string;
};

type PulsarVodData = {
  vod: PulsarVodFragment | null;
};

export function vodPulsarParams({ vod }: PulsarVodData): VideoParams | null {
  if (!isValidObject(vod)) {
    return null;
  }

  return {
    type: VideoType.Video,
    video: {
      id: convertToUnsafeID(vod.id),
    },
  };
}
