import { VideoType } from 'pulsar-player-core';
import { GQL_GARBAGE_OBJECT_ID, convertToUnsafeID } from 'tachyon-relay';
import { mockPulsarVodFragment } from '../test-mocks';
import type { PulsarVodFragment } from '.';
import { vodPulsarParams } from '.';

describe(vodPulsarParams, () => {
  it('returns null for invalid video data', () => {
    const invalidOverrides: Array<Partial<PulsarVodFragment> | null> = [
      null,
      { id: '' },
      { id: GQL_GARBAGE_OBJECT_ID },
    ];

    invalidOverrides.forEach((overrides) => {
      expect(
        vodPulsarParams({
          vod: overrides ? mockPulsarVodFragment(overrides) : null,
        }),
      ).toBeNull();
    });
  });

  it('maps values correctly', () => {
    const vod = mockPulsarVodFragment();

    expect(
      vodPulsarParams({
        vod,
      }),
    ).toEqual({
      type: VideoType.Video,
      video: {
        id: convertToUnsafeID(vod.id),
      },
    });
  });
});
