import { useState } from 'react';

export function useErrorPath(
  currentAsPath: string,
): [string | undefined, () => void] {
  const [erroringPath, setErroringPath] = useState<string | undefined>();

  function onError() {
    setErroringPath(currentAsPath);
  }

  // This allows us to gracefully exit an error state that bubbled all the way
  // up to the application level in the event that the user tries to navigate
  // away from the path that just caused an error.
  if (erroringPath && erroringPath !== currentAsPath) {
    setErroringPath(undefined);
  }

  return [erroringPath, onError];
}
