import { act, renderHook } from '@testing-library/react-hooks';
import { useErrorPath } from '.';

describe(useErrorPath, () => {
  it('sets the error path when onError is invoked', () => {
    const { result } = renderHook(useErrorPath, {
      initialProps: 'foo',
    });

    const [erroringPath, onError] = result.current;
    expect(erroringPath).toBeUndefined();
    act(() => onError());
    expect(result.current[0]).toEqual('foo');
  });

  it('unsets the error path when the currentAsPath changes', () => {
    const { rerender, result } = renderHook(useErrorPath, {
      initialProps: 'foo',
    });

    const [erroringPath, onError] = result.current;
    expect(erroringPath).toBeUndefined();
    act(() => onError());
    expect(result.current[0]).toEqual('foo');
    rerender('bar');
    expect(result.current[0]).toBeUndefined();
  });
});
