# Tachyon-Polyfill

A package to [polyfill](<https://en.wikipedia.org/wiki/Polyfill_(programming)>)
Browser features via Twitch's hosted version of
[Polyfill.io](https://polyfill.io/v2/). Currently we only support v2 of
Polyfill.io.

# Installation

```sh
yarn add tachyon-polyfill
```

# React Apps

```ts
import type { FC } from 'react';
import { PolyfillPreload, PolyfillScript } from 'tachyon-polyfill';

const App: FC = ({ userLocale }) => {
  return (
    <html>
      <head>
        {/* Optional: ensures this script download is priortized for perf reasons */}
        <PolyfillPreload locale={userLocale} />
      </head>
      <body>
        {/* Place above all app scripts to ensure availability of features */}
        <PolyfillScript locale={userLocale} />
        <script src="app.js" />
      </body>
    </html>
  );
};
```

# For Other Apps

For non-React applications we also expose the more primitive `getPolyfillUrl`
which will return you a string that can be templated into an HTML script
elements.

```ts
import { getPolyfillUrl } from 'tachyon-polyfill';

const polyfillUrl = getPolyfillUrl({ userLocale });
```
