import { Component } from 'react';
import type { PolyfillConfig } from '../polyfillUrl';
import { getPolyfillUrl } from '../polyfillUrl';

export type PolyfillProps = Partial<PolyfillConfig>;

// eslint-disable-next-line react/display-name
export abstract class PolyfillBase extends Component<PolyfillProps> {
  public abstract override render(): JSX.Element;

  protected get url(): string {
    return getPolyfillUrl(this.props);
  }
}
