import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { getPolyfillUrl } from '../polyfillUrl';
import { PolyfillPreload } from '.';

describe(PolyfillPreload, () => {
  const setup = createShallowWrapperFactory(PolyfillPreload, () => ({
    locale: 'en-US',
  }));

  it('generates the right link & script tags', () => {
    const { props, wrapper } = setup();

    expect(wrapper).toHaveProp({
      as: 'script',
      href: getPolyfillUrl(props),
      rel: 'preload',
    });
  });
});
