import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { getPolyfillUrl } from '../polyfillUrl';
import { PolyfillScript } from '.';

describe(PolyfillScript, () => {
  const setup = createShallowWrapperFactory(PolyfillScript, () => ({
    locale: 'en-US',
  }));

  it('generates the right link & script tags', () => {
    const { props, wrapper } = setup();

    expect(wrapper).toHaveProp({
      id: 'polyfill-script',
      src: getPolyfillUrl(props),
    });
  });
});
