# Tachyon Relay Build

A convenience package for setting up the Relay dependencies for dev-/build-time
interactions with `tachyon-relay`.

## Usage

`tachyon-relay` is a runtime dependency and should be added in the
`dependencies` list in `package.json`, and `tacyhon-relay-build` should be added
in `devDependencies`. This allows `tachyon-relay-build` and all of the
build-time Relay dependencies to be excluded from built apps (e.g. SSR apps with
server runtimes) via `yarn install --production` since all of the artifacts will
have already been generated at that point.

Your versions of `tacyhon-relay` and `tachyon-relay-build` must be the same to
ensure the versions of the relevant underlying Relay packages are kept in sync.

### Generating/Updating a GraphQL Schema

This package includes the command `update-gql-schema` that will read from a
`twitch-relay`
[cosmiconfig-compatible config file](https://github.com/davidtheclark/cosmiconfig#cosmiconfig)
to generate a local schema file. It takes three options:

- clientId: the twitch clientId associated with your apps
- schema: the path to save the schema file
- gqlEndpoint: (optional, defaults to
  `https://graphql.twitch.a2z.com/master/gql` which requires Amazon VPN) the
  GraphQL endpoint to connect to
