const { resolve } = require('path');
const configurator = require('../../../babel.configurator');

module.exports = (api) => {
  api.cache.using(() => process.env.NODE_ENV);

  const envConfig = {
    modules: !api.env('module') && 'auto',
  };

  const plugins = ['relay'];

  return configurator({
    envConfig,
    plugins,
  });
};
