export function getAuthorizationHeader(
  authorization?: string | (() => string | null) | null,
): string | null {
  if (!authorization) {
    return null;
  }

  const token =
    typeof authorization === 'function' ? authorization() : authorization;
  if (!token) {
    return null;
  }

  return `OAuth ${token}`;
}
