import { getAuthorizationHeader } from '.';

describe(getAuthorizationHeader, () => {
  it('null when no authorization function or literal is provided', () => {
    expect(getAuthorizationHeader()).toBeNull();
  });

  it('null when authorization function returns null', () => {
    expect(getAuthorizationHeader(() => null)).toBeNull();
  });

  it('formats bearer token when authorization function', () => {
    expect(getAuthorizationHeader(() => 'foo')).toEqual('OAuth foo');
  });

  it('formats bearer token when authorization literal', () => {
    expect(getAuthorizationHeader('foo')).toEqual('OAuth foo');
  });
});
