import type { FC, SuspenseProps } from 'react';
import { Suspense } from 'react';

/**
 * A Suspense component that is a noop on the server. Users must ensure that
 * children are not attempting to trigger Suspense during server renders.
 */
// istanbul ignore next: trivial
export const DangerousServerSuspense: FC<SuspenseProps> = ({
  children,
  fallback,
}) =>
  typeof window === 'undefined' ? (
    <>{children}</>
  ) : (
    <Suspense fallback={fallback}>{children}</Suspense>
  );
DangerousServerSuspense.displayName = 'DangerousServerSuspense';
