import type { FC } from 'react';
import { configuration } from '../../configuration';

/**
 * A component for preconnecting to the GraphQL API, useful in SSR situations
 * so that connection is available immediately upon app boot. Uses the endpoint
 * from the current tachyon-relay configuration.
 */
export const GraphqlPreconnect: FC = () => (
  <link
    crossOrigin="anonymous"
    href={configuration.gqlEndpoint}
    rel="preconnect"
  />
);

GraphqlPreconnect.displayName = 'GraphqlPreconnect';
