import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { configuration } from '../../configuration';
import { GraphqlPreconnect } from '.';

describe(GraphqlPreconnect, () => {
  const setup = createShallowWrapperFactory(GraphqlPreconnect);

  it('uses the domain from configuration', () => {
    const { wrapper } = setup();
    expect(wrapper).toHaveProp({
      crossOrigin: 'anonymous',
      href: configuration.gqlEndpoint,
      rel: 'preconnect',
    });
  });
});
