import type { ComponentType, FC } from 'react';
import { getComponentName } from 'tachyon-utils-react';
import type { RequestInfoContext } from './RequestInfoRoot';
import { useRequestInfo } from './useRequestInfo';

/**
 * Props for mixing into components wrapped by withRequestInfo.
 */
export type RequestInfoProps = RequestInfoContext;

export function withRequestInfo<P extends RequestInfoProps>(
  Comp: ComponentType<P>,
): FC<Omit<P, keyof RequestInfoProps>> {
  const RequestInfo: FC<Omit<P, keyof RequestInfoProps>> = (props) => {
    const requestInfo = useRequestInfo();

    return <Comp {...(props as P)} requestInfo={requestInfo} />;
  };
  RequestInfo.displayName = `RequestInfo(${getComponentName(Comp)})`;

  return RequestInfo;
}
