const queryNamePattern = /query (\w+_(?:Refetch)?Query)[(| ]/;

export const NO_MATCH_FALLBACK = 'Malformed_Query';

/**
 * Extracts a query name from a full GraphQL query string. Returns
 * 'Malformed_Query' in the case of no match, though hopefully another error
 * should've been thrown before getting here in that case.
 */
export function extractQueryName(query: string): string {
  return query.match(queryNamePattern)?.[1] || NO_MATCH_FALLBACK;
}
