import { NO_MATCH_FALLBACK, extractQueryName } from '.';

describe(extractQueryName, () => {
  interface ExtractTestCase {
    query: string;
    queryName: string;
  }

  it.each`
    queryName                  | query
    ${'RequestInfoRoot_Query'} | ${'query RequestInfoRoot_Query {'}
    ${'Clip_Query'}            | ${'query Clip_Query($slug: ID!) {'}
    ${'GameList_RefetchQuery'} | ${'query GameList_RefetchQuery($gamesCount: Int!, $cursor: Cursor) {'}
    ${NO_MATCH_FALLBACK}       | ${'query {'}
  `(
    'returns $queryName from $query',
    ({ query, queryName }: ExtractTestCase) => {
      expect(extractQueryName(query)).toEqual(queryName);
    },
  );
});
