import { logger } from 'tachyon-logger';
import type { GraphQLErrorType } from '../../../types';

export interface LogErrorParameters {
  details: string[] | string;
  errorCondition: GraphQLErrorType;
  status?: number;
}

/**
 * Wrapper around logger to include common fields for filtering.
 *
 * @param parameters The parameters that should be logged.
 */
export function logError(parameters: LogErrorParameters): void {
  const context = {
    ...parameters,
    details: JSON.stringify(parameters.details),
  };
  logger.error({
    category: 'errorTrackers',
    context,
    message: 'Failed GQL request',
    package: 'tachyon-relay',
  });
}
