import { datatype, lorem } from 'faker';
import { logger } from 'tachyon-logger';
import { GraphQLErrorType } from '../../../types';
import type { LogErrorParameters } from '.';
import { logError } from '.';

jest.mock('tachyon-logger', () => ({ logger: { error: jest.fn() } }));

describe(logError, () => {
  beforeEach(() => {
    (logger.error as jest.Mock).mockReset();
  });

  function getParams(): LogErrorParameters {
    return {
      details: lorem.words(),
      errorCondition: GraphQLErrorType.ConnectionError,
      status: datatype.number(),
    };
  }

  it('logs the right error', () => {
    const params = getParams();
    logError(params);

    const context = {
      ...params,
      details: JSON.stringify(params.details),
    };

    expect(logger.error).toHaveBeenCalledWith({
      category: 'errorTrackers',
      context,
      message: 'Failed GQL request',
      package: 'tachyon-relay',
    });
  });
});
