import { logger } from 'tachyon-logger';
import type { TwitchGraphQLResponse } from '../../types';

/**
 * Looks for info about services backing a GQL query and debug logs that list
 */
export function logServicesFromResponse(response: TwitchGraphQLResponse): void {
  const queries = response.extensions?.queries;
  if (queries) {
    const services = Array.from(
      new Set(queries.map(({ method }) => method.split('.')[1])),
    ).join(',');

    logger.debug({
      category: 'logServicesFromResponse',
      context: {
        services,
      },
      message: 'Services for GQL query',
      package: 'tachyon-relay',
    });
  }
}
